--[[---------------------------------------------------------------------------
	Chocolatier Two: Dice Game
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local char = gDialogTable.char
local betFont = { standardFontName, kThirtyTwo, DefaultColor }

-------------------------------------------------------------------------------

-- Gamble minimum 1% (minimum $100) of your cash, rounded to nearest $100
local minBet = bsgFloor(gSim.money * .01)
minBet = bsgFloor((minBet + 50)/ 100) * 100
if minBet < 100 then minBet = 100
elseif minBet > 1000000 then minBet = 1000000
end

-- Gamble maximum roughly 20% of your cash, up to 50% if very low
local maxBet = bsgFloor(gSim.money * .20)
if maxBet < minBet then maxBet = gSim.money * .5 end
if maxBet > 1000000 then maxBet = 1000000 end
if maxBet < minBet then maxBet = minBet end

if minBet == maxBet then maxBet = minBet * 2 end

-- Gamble in 10 increments from min to max, increments rounded to nearest $100
local deltaBet = bsgFloor((maxBet - minBet) / 10)
deltaBet = bsgFloor((deltaBet + 50) / 100) * 100
maxBet = minBet + 10 * deltaBet

-- Allow gambling up to 50% of cash in extreme cases, with delta not necessarily rounded
if maxBet > gSim.money / 2 then
	maxBet = gSim.money / 2
	maxBet = bsgFloor(maxBet / 100) * 100
	deltaBet = bsgFloor((maxBet - minBet) / 10)
	maxBet = minBet + 10 * deltaBet
end

-- And finally, just in case the numbers are really screwy...
if maxBet < minBet then
	maxBet = minBet
	deltaBet = 0
end

local ante = minBet
local bet = minBet
local winnings = 0

-------------------------------------------------------------------------------

local function UpdateBet()
	SetLabel("pot", bsgDollars(bet))
	EnableWindow("bet_less", (bet > minBet))
	EnableWindow("bet_more", (bet < maxBet))
end

local function LowerBet()
	bet = bet - deltaBet
	UpdateBet()
end

local function RaiseBet()
	bet = bet + deltaBet
	UpdateBet()
end

-------------------------------------------------------------------------------

local function StartGame()
	gDiceRollCount = 0
	
	EnableWindow("start", false)
	EnableWindow("cancel", false)
	SetLabel("ante", GetString("your_bet"))

	-- Take the ante away immediately and roll the first two dice
	gSim:AdjustMoney(-ante)
	EnableWindow("stop", true)
	RollFirst()
	while gDiceRollCount < 2 do
		Pause(50)
	end	
	EnableWindow("stop", false)
	EnableWindow("roll", true)

	local s = GetString("name_roll", gSim.player) .. ": " .. tostring(PlayerTotal())
	SetLabel("player", s)
	local s = GetString("name_roll", GetString(char.name)) .. ": ??"
	SetLabel("character", s)
	
	local s = GetString("gamble_dice_instructions_2", tostring(PlayerTotal()), bsgDollars(ante))
	SetLabel("instructions", s)
--	bet = bet + 5 * deltaBet
	UpdateBet()
end

local function AcceptBet()
	EnableWindow("bet_more", false)
	EnableWindow("bet_less", false)
	EnableWindow("cancel", false)
	EnableWindow("roll", false)
	
	EnableWindow("stop", true)
	RollSecond()
	while gDiceRollCount < 8 do
		Pause(50)
	end
	EnableWindow("stop", false)
	
	local playerTotal = PlayerTotal()
	local charTotal = CharacterTotal()
	
	local s = GetString("name_roll", gSim.player) .. ": " .. tostring(playerTotal)
	SetLabel("player", s)
	local s = GetString("name_roll", GetString(char.name)) .. ": " .. tostring(charTotal)
	SetLabel("character", s)

	-- Ante amount has already been subtracted
	local stake = bet - ante
	local message = nil
	local total = 0
	if playerTotal < charTotal then
		-- Already lost ante, lose the rest
		gSim:AdjustMoney(-stake)
		message = "char_wins"
		total = -bet
		PlaySound("dice_lose")
	elseif playerTotal > charTotal then
		-- Return ante PLUS bet
		gSim:AdjustMoney(ante + bet)
		message = "player_wins"
		total = bet
		PlaySound("dice_win")
	else
		-- Tie - ante already removed
		message = "tie"
		total = -ante
	end
	SetLabel("instructions", GetString(message, bsgDollars(ante), bsgDollars(bet)))
	
	if total > 0 then
		gSim:Message(GetString("message_wondice", bsgDollars(total)))
	elseif total < 0 then
		gSim:Message(GetString("message_lostdice", bsgDollars(-total)))
	end

	-- FIRSTPEEK: DiceGame, time-stamp, weeks, money, ante, bet, total
	if fpWrite then fpWrite { "DiceGame", gSim.weeks, gSim.money, ante, bet, total } end
	
	EnableWindow("done", true)
end

-------------------------------------------------------------------------------

local w=600
local h=400
local charX = w - ui.charW

local xDice = 103

local startup = "#"..GetString("gamble_dice_instructions_1", bsgDollars(ante))

MakeDialog
{
	Frame
	{
		x=100+ui.xOffset,y=50+ui.yOffset,w=600,h=400,fit=true,
		Text { x=0,y=0,w=w-ui.charW,h=ui.charH-50, name="instructions", label=startup, font=dialogFont, },

		TextButton { x=charX+(ui.charW - ui.devButtonW)/2,y=kMax-50, name="cancel", label="cancel", close=true },
		TextButton { x=charX+(ui.charW - ui.devButtonW)/2,y=kMax-50, name="done", label="done", close=true },

		Text { x=charX,y=255,w=ui.charW-24,h=20, name="ante", label="ante", font=dialogFont },
		Text { x=charX,y=275,w=ui.charW-24,h=49, name="pot", label="#"..bsgDollars(bet), font=betFont },
		Button { x=charX+ui.charW-24,y=275, command=RaiseBet, name="bet_more",
				graphics={"control/scrollup_up", "control/scrollup_down", "control/scrollup_over"} },
		Button { x=charX+ui.charW-24,y=300, command=LowerBet, name="bet_less",
			graphics={"control/scrolldown_up", "control/scrolldown_down", "control/scrolldown_over"}, },

		DiceGame
		{
			x=kCenter,y=kCenter,w=kMax-ui.charW,h=kMax,fit=true,
			
			Text { x=0,y=170,w=kMax,h=20, name="character", label="#"..GetString("name_roll", GetString(char.name)), font=dialogFont },
			Bitmap { x=xDice,y=190, name="die_4", image="image/die_unknown" },
			Bitmap { x=xDice+50,y=190, name="die_5", image="image/die_unknown" },
			Bitmap { x=xDice+100,y=190, name="die_6", image="image/die_unknown" },
			Bitmap { x=xDice+150,y=190, name="die_7", image="image/die_unknown" },
--			Text { x=xDice+200,y=190,w=50,h=50, name="char_total", font=dialogFont },

			Text { x=0,y=270,w=kMax,h=20, name="player", label="#"..GetString("name_roll", gSim.player), font=dialogFont },
			Bitmap { x=xDice,y=290, name="die_0", image="image/die_unknown" },
			Bitmap { x=xDice+50,y=290, name="die_1", image="image/die_unknown" },
			Bitmap { x=xDice+100,y=290, name="die_2", image="image/die_unknown" },
			Bitmap { x=xDice+150,y=290, name="die_3", image="image/die_unknown" },
--			Text { x=xDice+200,y=290,w=50,h=50, name="player_total", font=dialogFont },

			TextButton { x=xDice + 6 + (200 - ui.devButtonW)/2,y=kMax-50, name="stop", label="roll_stop", command=function() StopOne() end },
			TextButton { x=xDice + 6 + (200 - ui.devButtonW)/2,y=kMax-50, name="start", label="roll_dice", command=StartGame, sound="sfx/roll_dice.ogg" },
			TextButton { x=xDice + 6 + (200 - ui.devButtonW)/2,y=kMax-50, name="roll", label="roll_dice", command=AcceptBet, sound="sfx/roll_dice.ogg" },
		}
	},
	char:Visual(ui.screenWidth-100-ui.charW+ui.xOffset, ui.yOffset, charNameFontDark),
}

EnableWindow("roll_dice", false)
EnableWindow("bet_more", false)
EnableWindow("bet_less", false)
EnableWindow("done", false)
EnableWindow("roll", false)
EnableWindow("stop", false)
